//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 16:44:39 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: five_point_suspension_c
//
//	==> Number of joints: 16
//
//	==> Function: F6 - Sensors Kinematics
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"
#include "mbs_sensor.h"

void mbs_sensor(MbsSensor *sens,
MbsData *s, int isens)
{
#include "mbs_sensor_five_point_suspension_c.h"

double *q, *qd, *qdd;
double **dpt;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
 
// Trigonometric functions

S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics


switch(isens)
{
case 1:

ROcp1_211 = C10*S11;
ROcp1_311 = S10*S11;
ROcp1_511 = C10*C11;
ROcp1_611 = S10*C11;
ROcp1_412 = -S11*C12;
ROcp1_512 = ROcp1_511*C12-S10*S12;
ROcp1_612 = ROcp1_611*C12+C10*S12;
ROcp1_712 = S11*S12;
ROcp1_812 = -ROcp1_511*S12-S10*C12;
ROcp1_912 = -ROcp1_611*S12+C10*C12;
ROcp1_113 = -ROcp1_712*S13+C11*C13;
ROcp1_213 = ROcp1_211*C13-ROcp1_812*S13;
ROcp1_313 = ROcp1_311*C13-ROcp1_912*S13;
ROcp1_713 = ROcp1_712*C13+C11*S13;
ROcp1_813 = ROcp1_211*S13+ROcp1_812*C13;
ROcp1_913 = ROcp1_311*S13+ROcp1_912*C13;
ROcp1_114 = ROcp1_113*C14+ROcp1_412*S14;
ROcp1_214 = ROcp1_213*C14+ROcp1_512*S14;
ROcp1_314 = ROcp1_313*C14+ROcp1_612*S14;
ROcp1_414 = -ROcp1_113*S14+ROcp1_412*C14;
ROcp1_514 = -ROcp1_213*S14+ROcp1_512*C14;
ROcp1_614 = -ROcp1_313*S14+ROcp1_612*C14;
ROcp1_115 = ROcp1_114*C15-ROcp1_713*S15;
ROcp1_215 = ROcp1_214*C15-ROcp1_813*S15;
ROcp1_315 = ROcp1_314*C15-ROcp1_913*S15;
ROcp1_715 = ROcp1_114*S15+ROcp1_713*C15;
ROcp1_815 = ROcp1_214*S15+ROcp1_813*C15;
ROcp1_915 = ROcp1_314*S15+ROcp1_913*C15;
POcp1_32 = q[1]+dpt[3][6];
OMcp1_23 = -qd[11]*S10;
OMcp1_33 = qd[11]*C10;
OPcp1_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp1_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp1_14 = -dpt[2][12]*S11;
RLcp1_24 = ROcp1_511*dpt[2][12];
RLcp1_34 = ROcp1_611*dpt[2][12];
POcp1_14 = RLcp1_14+dpt[1][6];
POcp1_24 = RLcp1_24+dpt[2][6];
POcp1_34 = POcp1_32+RLcp1_34;
JTcp1_14_3 = -RLcp1_24*C10-RLcp1_34*S10;
JTcp1_24_3 = RLcp1_14*C10;
JTcp1_34_3 = RLcp1_14*S10;
OMcp1_14 = qd[10]+qd[12]*C11;
OMcp1_24 = OMcp1_23+ROcp1_211*qd[12];
OMcp1_34 = OMcp1_33+ROcp1_311*qd[12];
ORcp1_14 = OMcp1_23*RLcp1_34-OMcp1_33*RLcp1_24;
ORcp1_24 = OMcp1_33*RLcp1_14-RLcp1_34*qd[10];
ORcp1_34 = -OMcp1_23*RLcp1_14+RLcp1_24*qd[10];
VIcp1_34 = ORcp1_34+qd[1];
OPcp1_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp1_23*ROcp1_311-OMcp1_33*ROcp1_211);
OPcp1_24 = OPcp1_23+ROcp1_211*qdd[12]+qd[12]*(OMcp1_33*C11-ROcp1_311*qd[10]);
OPcp1_34 = OPcp1_33+ROcp1_311*qdd[12]+qd[12]*(-OMcp1_23*C11+ROcp1_211*qd[10]);
ACcp1_14 = OMcp1_23*ORcp1_34-OMcp1_33*ORcp1_24+OPcp1_23*RLcp1_34-OPcp1_33*RLcp1_24;
ACcp1_24 = OMcp1_33*ORcp1_14+OPcp1_33*RLcp1_14-ORcp1_34*qd[10]-RLcp1_34*qdd[10];
ACcp1_34 = qdd[1]-OMcp1_23*ORcp1_14-OPcp1_23*RLcp1_14+ORcp1_24*qd[10]+RLcp1_24*qdd[10];
OMcp1_15 = OMcp1_14+ROcp1_412*qd[13];
OMcp1_25 = OMcp1_24+ROcp1_512*qd[13];
OMcp1_35 = OMcp1_34+ROcp1_612*qd[13];
OPcp1_15 = OPcp1_14+ROcp1_412*qdd[13]+qd[13]*(OMcp1_24*ROcp1_612-OMcp1_34*ROcp1_512);
OPcp1_25 = OPcp1_24+ROcp1_512*qdd[13]+qd[13]*(-OMcp1_14*ROcp1_612+OMcp1_34*ROcp1_412);
OPcp1_35 = OPcp1_34+ROcp1_612*qdd[13]+qd[13]*(OMcp1_14*ROcp1_512-OMcp1_24*ROcp1_412);
OMcp1_16 = OMcp1_15+ROcp1_713*qd[14];
OMcp1_26 = OMcp1_25+ROcp1_813*qd[14];
OMcp1_36 = OMcp1_35+ROcp1_913*qd[14];
OPcp1_16 = OPcp1_15+ROcp1_713*qdd[14]+qd[14]*(OMcp1_25*ROcp1_913-OMcp1_35*ROcp1_813);
OPcp1_26 = OPcp1_25+ROcp1_813*qdd[14]+qd[14]*(-OMcp1_15*ROcp1_913+OMcp1_35*ROcp1_713);
OPcp1_36 = OPcp1_35+ROcp1_913*qdd[14]+qd[14]*(OMcp1_15*ROcp1_813-OMcp1_25*ROcp1_713);
RLcp1_17 = ROcp1_114*dpt[1][14]+ROcp1_414*dpt[2][14]+ROcp1_713*dpt[3][14];
RLcp1_27 = ROcp1_214*dpt[1][14]+ROcp1_514*dpt[2][14]+ROcp1_813*dpt[3][14];
RLcp1_37 = ROcp1_314*dpt[1][14]+ROcp1_614*dpt[2][14]+ROcp1_913*dpt[3][14];
POcp1_17 = POcp1_14+RLcp1_17;
POcp1_27 = POcp1_24+RLcp1_27;
POcp1_37 = POcp1_34+RLcp1_37;
JTcp1_27_2 = -RLcp1_34-RLcp1_37;
JTcp1_37_2 = RLcp1_24+RLcp1_27;
JTcp1_17_3 = JTcp1_14_3-RLcp1_27*C10-RLcp1_37*S10;
JTcp1_27_3 = JTcp1_24_3+RLcp1_17*C10;
JTcp1_37_3 = JTcp1_34_3+RLcp1_17*S10;
JTcp1_17_4 = -RLcp1_27*ROcp1_311+RLcp1_37*ROcp1_211;
JTcp1_27_4 = RLcp1_17*ROcp1_311-RLcp1_37*C11;
JTcp1_37_4 = -RLcp1_17*ROcp1_211+RLcp1_27*C11;
JTcp1_17_5 = -RLcp1_27*ROcp1_612+RLcp1_37*ROcp1_512;
JTcp1_27_5 = RLcp1_17*ROcp1_612-RLcp1_37*ROcp1_412;
JTcp1_37_5 = -RLcp1_17*ROcp1_512+RLcp1_27*ROcp1_412;
JTcp1_17_6 = -RLcp1_27*ROcp1_913+RLcp1_37*ROcp1_813;
JTcp1_27_6 = RLcp1_17*ROcp1_913-RLcp1_37*ROcp1_713;
JTcp1_37_6 = -RLcp1_17*ROcp1_813+RLcp1_27*ROcp1_713;
OMcp1_17 = OMcp1_16+ROcp1_414*qd[15];
OMcp1_27 = OMcp1_26+ROcp1_514*qd[15];
OMcp1_37 = OMcp1_36+ROcp1_614*qd[15];
ORcp1_17 = OMcp1_26*RLcp1_37-OMcp1_36*RLcp1_27;
ORcp1_27 = -OMcp1_16*RLcp1_37+OMcp1_36*RLcp1_17;
ORcp1_37 = OMcp1_16*RLcp1_27-OMcp1_26*RLcp1_17;
VIcp1_17 = ORcp1_14+ORcp1_17;
VIcp1_27 = ORcp1_24+ORcp1_27;
VIcp1_37 = ORcp1_37+VIcp1_34;
OPcp1_17 = OPcp1_16+ROcp1_414*qdd[15]+qd[15]*(OMcp1_26*ROcp1_614-OMcp1_36*ROcp1_514);
OPcp1_27 = OPcp1_26+ROcp1_514*qdd[15]+qd[15]*(-OMcp1_16*ROcp1_614+OMcp1_36*ROcp1_414);
OPcp1_37 = OPcp1_36+ROcp1_614*qdd[15]+qd[15]*(OMcp1_16*ROcp1_514-OMcp1_26*ROcp1_414);
ACcp1_17 = ACcp1_14+OMcp1_26*ORcp1_37-OMcp1_36*ORcp1_27+OPcp1_26*RLcp1_37-OPcp1_36*RLcp1_27;
ACcp1_27 = ACcp1_24-OMcp1_16*ORcp1_37+OMcp1_36*ORcp1_17-OPcp1_16*RLcp1_37+OPcp1_36*RLcp1_17;
ACcp1_37 = ACcp1_34+OMcp1_16*ORcp1_27-OMcp1_26*ORcp1_17+OPcp1_16*RLcp1_27-OPcp1_26*RLcp1_17;
sens->P[1] = POcp1_17;
sens->P[2] = POcp1_27;
sens->P[3] = POcp1_37;
sens->R[1][1] = ROcp1_115;
sens->R[1][2] = ROcp1_215;
sens->R[1][3] = ROcp1_315;
sens->R[2][1] = ROcp1_414;
sens->R[2][2] = ROcp1_514;
sens->R[2][3] = ROcp1_614;
sens->R[3][1] = ROcp1_715;
sens->R[3][2] = ROcp1_815;
sens->R[3][3] = ROcp1_915;
sens->V[1] = VIcp1_17;
sens->V[2] = VIcp1_27;
sens->V[3] = VIcp1_37;
sens->OM[1] = OMcp1_17;
sens->OM[2] = OMcp1_27;
sens->OM[3] = OMcp1_37;
sens->J[1][11] = JTcp1_17_3;
sens->J[1][12] = JTcp1_17_4;
sens->J[1][13] = JTcp1_17_5;
sens->J[1][14] = JTcp1_17_6;
sens->J[2][10] = JTcp1_27_2;
sens->J[2][11] = JTcp1_27_3;
sens->J[2][12] = JTcp1_27_4;
sens->J[2][13] = JTcp1_27_5;
sens->J[2][14] = JTcp1_27_6;
sens->J[3][1] = (1.0);
sens->J[3][10] = JTcp1_37_2;
sens->J[3][11] = JTcp1_37_3;
sens->J[3][12] = JTcp1_37_4;
sens->J[3][13] = JTcp1_37_5;
sens->J[3][14] = JTcp1_37_6;
sens->J[4][10] = (1.0);
sens->J[4][12] = C11;
sens->J[4][13] = ROcp1_412;
sens->J[4][14] = ROcp1_713;
sens->J[4][15] = ROcp1_414;
sens->J[5][11] = -S10;
sens->J[5][12] = ROcp1_211;
sens->J[5][13] = ROcp1_512;
sens->J[5][14] = ROcp1_813;
sens->J[5][15] = ROcp1_514;
sens->J[6][11] = C10;
sens->J[6][12] = ROcp1_311;
sens->J[6][13] = ROcp1_612;
sens->J[6][14] = ROcp1_913;
sens->J[6][15] = ROcp1_614;
sens->A[1] = ACcp1_17;
sens->A[2] = ACcp1_27;
sens->A[3] = ACcp1_37;
sens->OMP[1] = OPcp1_17;
sens->OMP[2] = OPcp1_27;
sens->OMP[3] = OPcp1_37;

break;

case 2:

ROcp2_211 = C10*S11;
ROcp2_311 = S10*S11;
ROcp2_511 = C10*C11;
ROcp2_611 = S10*C11;
ROcp2_412 = -S11*C12;
ROcp2_512 = ROcp2_511*C12-S10*S12;
ROcp2_612 = ROcp2_611*C12+C10*S12;
ROcp2_712 = S11*S12;
ROcp2_812 = -ROcp2_511*S12-S10*C12;
ROcp2_912 = -ROcp2_611*S12+C10*C12;
ROcp2_113 = -ROcp2_712*S13+C11*C13;
ROcp2_213 = ROcp2_211*C13-ROcp2_812*S13;
ROcp2_313 = ROcp2_311*C13-ROcp2_912*S13;
ROcp2_713 = ROcp2_712*C13+C11*S13;
ROcp2_813 = ROcp2_211*S13+ROcp2_812*C13;
ROcp2_913 = ROcp2_311*S13+ROcp2_912*C13;
ROcp2_114 = ROcp2_113*C14+ROcp2_412*S14;
ROcp2_214 = ROcp2_213*C14+ROcp2_512*S14;
ROcp2_314 = ROcp2_313*C14+ROcp2_612*S14;
ROcp2_414 = -ROcp2_113*S14+ROcp2_412*C14;
ROcp2_514 = -ROcp2_213*S14+ROcp2_512*C14;
ROcp2_614 = -ROcp2_313*S14+ROcp2_612*C14;
ROcp2_115 = ROcp2_114*C15-ROcp2_713*S15;
ROcp2_215 = ROcp2_214*C15-ROcp2_813*S15;
ROcp2_315 = ROcp2_314*C15-ROcp2_913*S15;
ROcp2_715 = ROcp2_114*S15+ROcp2_713*C15;
ROcp2_815 = ROcp2_214*S15+ROcp2_813*C15;
ROcp2_915 = ROcp2_314*S15+ROcp2_913*C15;
POcp2_32 = q[1]+dpt[3][6];
OMcp2_23 = -qd[11]*S10;
OMcp2_33 = qd[11]*C10;
OPcp2_23 = -qdd[11]*S10-qd[10]*qd[11]*C10;
OPcp2_33 = qdd[11]*C10-qd[10]*qd[11]*S10;
RLcp2_14 = -dpt[2][12]*S11;
RLcp2_24 = ROcp2_511*dpt[2][12];
RLcp2_34 = ROcp2_611*dpt[2][12];
POcp2_14 = RLcp2_14+dpt[1][6];
POcp2_24 = RLcp2_24+dpt[2][6];
POcp2_34 = POcp2_32+RLcp2_34;
OMcp2_14 = qd[10]+qd[12]*C11;
OMcp2_24 = OMcp2_23+ROcp2_211*qd[12];
OMcp2_34 = OMcp2_33+ROcp2_311*qd[12];
ORcp2_14 = OMcp2_23*RLcp2_34-OMcp2_33*RLcp2_24;
ORcp2_24 = OMcp2_33*RLcp2_14-RLcp2_34*qd[10];
ORcp2_34 = -OMcp2_23*RLcp2_14+RLcp2_24*qd[10];
VIcp2_34 = ORcp2_34+qd[1];
OPcp2_14 = qdd[10]+qdd[12]*C11+qd[12]*(OMcp2_23*ROcp2_311-OMcp2_33*ROcp2_211);
OPcp2_24 = OPcp2_23+ROcp2_211*qdd[12]+qd[12]*(OMcp2_33*C11-ROcp2_311*qd[10]);
OPcp2_34 = OPcp2_33+ROcp2_311*qdd[12]+qd[12]*(-OMcp2_23*C11+ROcp2_211*qd[10]);
ACcp2_14 = OMcp2_23*ORcp2_34-OMcp2_33*ORcp2_24+OPcp2_23*RLcp2_34-OPcp2_33*RLcp2_24;
ACcp2_24 = OMcp2_33*ORcp2_14+OPcp2_33*RLcp2_14-ORcp2_34*qd[10]-RLcp2_34*qdd[10];
ACcp2_34 = qdd[1]-OMcp2_23*ORcp2_14-OPcp2_23*RLcp2_14+ORcp2_24*qd[10]+RLcp2_24*qdd[10];
OMcp2_15 = OMcp2_14+ROcp2_412*qd[13];
OMcp2_25 = OMcp2_24+ROcp2_512*qd[13];
OMcp2_35 = OMcp2_34+ROcp2_612*qd[13];
OPcp2_15 = OPcp2_14+ROcp2_412*qdd[13]+qd[13]*(OMcp2_24*ROcp2_612-OMcp2_34*ROcp2_512);
OPcp2_25 = OPcp2_24+ROcp2_512*qdd[13]+qd[13]*(-OMcp2_14*ROcp2_612+OMcp2_34*ROcp2_412);
OPcp2_35 = OPcp2_34+ROcp2_612*qdd[13]+qd[13]*(OMcp2_14*ROcp2_512-OMcp2_24*ROcp2_412);
OMcp2_16 = OMcp2_15+ROcp2_713*qd[14];
OMcp2_26 = OMcp2_25+ROcp2_813*qd[14];
OMcp2_36 = OMcp2_35+ROcp2_913*qd[14];
OPcp2_16 = OPcp2_15+ROcp2_713*qdd[14]+qd[14]*(OMcp2_25*ROcp2_913-OMcp2_35*ROcp2_813);
OPcp2_26 = OPcp2_25+ROcp2_813*qdd[14]+qd[14]*(-OMcp2_15*ROcp2_913+OMcp2_35*ROcp2_713);
OPcp2_36 = OPcp2_35+ROcp2_913*qdd[14]+qd[14]*(OMcp2_15*ROcp2_813-OMcp2_25*ROcp2_713);
RLcp2_17 = ROcp2_114*dpt[1][14]+ROcp2_414*dpt[2][14]+ROcp2_713*dpt[3][14];
RLcp2_27 = ROcp2_214*dpt[1][14]+ROcp2_514*dpt[2][14]+ROcp2_813*dpt[3][14];
RLcp2_37 = ROcp2_314*dpt[1][14]+ROcp2_614*dpt[2][14]+ROcp2_913*dpt[3][14];
POcp2_17 = POcp2_14+RLcp2_17;
POcp2_27 = POcp2_24+RLcp2_27;
POcp2_37 = POcp2_34+RLcp2_37;
OMcp2_17 = OMcp2_16+ROcp2_414*qd[15];
OMcp2_27 = OMcp2_26+ROcp2_514*qd[15];
OMcp2_37 = OMcp2_36+ROcp2_614*qd[15];
ORcp2_17 = OMcp2_26*RLcp2_37-OMcp2_36*RLcp2_27;
ORcp2_27 = -OMcp2_16*RLcp2_37+OMcp2_36*RLcp2_17;
ORcp2_37 = OMcp2_16*RLcp2_27-OMcp2_26*RLcp2_17;
VIcp2_17 = ORcp2_14+ORcp2_17;
VIcp2_27 = ORcp2_24+ORcp2_27;
VIcp2_37 = ORcp2_37+VIcp2_34;
OPcp2_17 = OPcp2_16+ROcp2_414*qdd[15]+qd[15]*(OMcp2_26*ROcp2_614-OMcp2_36*ROcp2_514);
OPcp2_27 = OPcp2_26+ROcp2_514*qdd[15]+qd[15]*(-OMcp2_16*ROcp2_614+OMcp2_36*ROcp2_414);
OPcp2_37 = OPcp2_36+ROcp2_614*qdd[15]+qd[15]*(OMcp2_16*ROcp2_514-OMcp2_26*ROcp2_414);
ACcp2_17 = ACcp2_14+OMcp2_26*ORcp2_37-OMcp2_36*ORcp2_27+OPcp2_26*RLcp2_37-OPcp2_36*RLcp2_27;
ACcp2_27 = ACcp2_24-OMcp2_16*ORcp2_37+OMcp2_36*ORcp2_17-OPcp2_16*RLcp2_37+OPcp2_36*RLcp2_17;
ACcp2_37 = ACcp2_34+OMcp2_16*ORcp2_27-OMcp2_26*ORcp2_17+OPcp2_16*RLcp2_27-OPcp2_26*RLcp2_17;
sens->P[1] = POcp2_17;
sens->P[2] = POcp2_27;
sens->P[3] = POcp2_37;
sens->R[1][1] = ROcp2_115;
sens->R[1][2] = ROcp2_215;
sens->R[1][3] = ROcp2_315;
sens->R[2][1] = ROcp2_414;
sens->R[2][2] = ROcp2_514;
sens->R[2][3] = ROcp2_614;
sens->R[3][1] = ROcp2_715;
sens->R[3][2] = ROcp2_815;
sens->R[3][3] = ROcp2_915;
sens->V[1] = VIcp2_17;
sens->V[2] = VIcp2_27;
sens->V[3] = VIcp2_37;
sens->OM[1] = OMcp2_17;
sens->OM[2] = OMcp2_27;
sens->OM[3] = OMcp2_37;
sens->A[1] = ACcp2_17;
sens->A[2] = ACcp2_27;
sens->A[3] = ACcp2_37;
sens->OMP[1] = OPcp2_17;
sens->OMP[2] = OPcp2_27;
sens->OMP[3] = OPcp2_37;

break;

default:

break;

}


// Number of continuation lines = 0

}
